-- Macro Scripts File


/* revision history


	13 Jan 2004, Alexander Bicalho
		added Target Camera with Elevation for VIZ Render
		Removed "VIZR" from the product list of the regular Target Camera

	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products
		consolidated the preview DOF macro from the Macro_Render.mcr

       22 Juillet 2003; Pierre-Felix Breton
                Modified to use the old match camera to view when a camera is selected
       24 Mai 2003; Pierre-Felix Breton
                Migrated VIZ 4 functionality in 3ds MAX 6

	August 29 2001 Pierre-Felix Breton
		Added Macro allowing creating a camera from the selected Perspective Viewport
	
	August 30th 2001 Pierre-Felix Breton
	added test for properties so the 'select target' don't show on free cameras anymore
	
	Sept 12 2001 Pierre-Felix Breton
	added a Macro allowing applying the Correction Modifier from the Quad menu.
	
	17 Nov 1998; Frank Delise: initial implementation
*/

-- Macro Scripts for Cameras
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK


--***********************************************************************************************
-- Creation Macros
-- enables actions for creation from menus and quads
------------------------------------------------------------------------------------------
macroScript Free_Camera 
	category:~FREE_CAMERA_CAPTION~ 
	internalCategory:"Lights and Cameras" 
	tooltip:~FREE_CAMERA_TOOLTIP~ 
	buttontext:~FREE_CAMERA_BUTTONTEXT~ 
	icon:#("Cameras",2)
	--palettehint: Cameras --used for publishing to palettes
(
	on execute do
	(
		StartObjectCreation FreeCamera
	)
	on isChecked do
	(
		mcrUtils.IsCreating FreeCamera
	)
)
------------------------------------------------------------------------------------------
macroScript Target_Camera 
	category:~TARGET_CAMERA_CATEGORY~ 
	internalCategory:"Lights and Cameras" 
	tooltip:~TARGET_CAMERA_TOOLTIP~ 
	buttontext:~TARGET_CAMERA_BUTTONTEXT~ 
	icon:#("Cameras",1)
	--palettehint: Cameras --used for publishing to palettes
(
	on execute do
	(
		StartObjectCreation TargetCamera
	)   
	on isChecked do
	(
		mcrUtils.IsCreating Target_Camera
	)
)
------------------------------------------------------------------------------------------
macroScript Physical_Camera 
	category:~PHYSICAL_CAMERA_CATEGORY~ 
	internalCategory:"Lights and Cameras" 
	tooltip:~PHYSICAL_CAMERA_TOOLTIP~ 
	buttontext:~PHYSICAL_CAMERA_BUTTONTEXT~ 
	icon:#("Cameras",1)
	--palettehint: Cameras --used for publishing to palettes
(
	on execute do
	(
		StartObjectCreation Physical_Camera
	)   
	on isChecked do
	(
		mcrUtils.IsCreating Physical_Camera
	)
)

--***********************************************************************************************
-- Create Camera from View

macroScript StandardCamera_CreateFromView
	ButtonText:~CREATE_STANDARDCAMERA_FROM_VIEW_BUTTONTEXT~
	category:~CAMERA_CREATEFROMVIEW_CATEGORY~ 
	internalCategory:"Lights and Cameras" 
	Tooltip:~CREATE_STANDARDCAMERA_FROM_VIEW_TOOLTIP~
	Icon:#("Cameras",3)
(

	On IsEnabled Return (If (viewport.Gettype() == #view_persp_user) and (not theHold.Holding()) do return true)
	On Execute Do
	( 
		CreateCameraFromView(FreeCamera)
	)--end on execute
)--end macro

macroScript PhysicalCamera_CreateFromView
	ButtonText:~CREATE_PHYSICALCAMERA_FROM_VIEW_BUTTONTEXT~
	category:~CAMERA_CREATEFROMVIEW_CATEGORY~ 
	internalCategory:"Lights and Cameras" 
	Tooltip:~CREATE_PHYSICALCAMERA_FROM_VIEW_TOOLTIP~
	Icon:#("Cameras",3)
(

	On IsEnabled Return (If (viewport.Gettype() == #view_persp_user) and (not theHold.Holding()) do return true)
	On Execute Do
	( 
		CreateCameraFromView(Physical_Camera)
	)--end on execute
)--end macro

--***********************************************************************************************
-- Selection macros

MacroScript Camera_SelectTarget
	ButtonText:~CAMERA_SELECTTARGET_BUTTONTEXT~
	category:~CAMERA_SELECTTARGET_CATEGORY~ 
	internalCategory:"Lights and Cameras" 
	Tooltip:~CAMERA_SELECTTARGET_TOOLTIP~ 
(

	On IsVisible Return ((Filters.Is_Camera $) and(IsValidNode $.target)) -- pfb, aug 30th 2001, added test for properties so the 'select target' don't show on Omnis anymore
	On Execute Do Try(select $.Target) Catch()
)



--***********************************************************************************************
-- Viewport Macros
macroScript Camera_ActivateView
ButtonText:~CAMERA_ACTIVATEVIEW_BUTTONTEXT~
category:~CAMERA_ACTIVATEVIEW_CATEGORY~ 
	internalCategory:"Lights and Cameras" 
	Tooltip:~CAMERA_ACTIVATEVIEW_TOOLTIP~
(

	On IsVisible Return ((Filters.Is_Camera $) and (viewport.getcamera() != $) and (viewport.canSetToViewport $) )
	On Execute Do
	( 
		Try(viewport.setcamera $) Catch()
	)
)


--***********************************************************************************************
-- Perspective Correction
-- this function is similar to the CameraCorrection available in the Macros_Modifers.mcr
-- the only difference is in the Visibility flags for Quads
-- the reason for this is to have the menu item visible from the pulldown | Modifier menu
-- AND control the visibility in the quads.  Doing this requires a duplicated definition of the macros

macroScript CameraCorrection_Quad 
	category:~CAMERACORRECTION_QUAD_CATEGORY~ 
	internalCategory:"Lights and Cameras" 
	tooltip:~CAMERACORRECTION_QUAD_TOOLTIP~ 
	ButtonText:~CAMERACORRECTION_QUAD_BUTTONTEXT~
(
    on execute do addMod CamPerspCorrect
    on isVisible return (Filters.Is_Camera $)
)


--***********************************************************************************************
-- Preview DOF

macroScript Preview_DOF 
	ButtonText:~PREVIEW_DOF_BUTTONTEXT~ 
	category:~PREVIEW_DOF_CATEGORY~ 
	internalCategory:"Render" 
	tooltip:~PREVIEW_DOF_TOOLTIP~ 
	buttontext:~PREVIEW_DOF_IN_VIEWPORT_BUTTONTEXT~        
(
	Try(MaxOps.displayActiveCameraViewWithMultiPassEffect())Catch()
)

